<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title><?php  echo APP_TITLE.':'.$page_title ;?></title>

    <!-- Bootstrap -->
    <link href="<?=CSS?>style.css" rel="stylesheet">
    <link href="<?=CSS?>bootstrap.min.css" rel="stylesheet">
    <link href="<?=CSS?>dataTables.bootstrap.min.css" rel="stylesheet">
    <link href="<?=CSS?>fixedHeader.bootstrap.min.css" rel="stylesheet">
    <link href="<?=CSS?>font-awesome.min.css" rel="stylesheet"> 
    <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700,900" rel="stylesheet"> 
<link rel='shortcut icon' type='image/x-icon' href='http://fastsmsalerts.com/resources/images/favicon.ico.png' />

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
    <div id="wrapper">
      <div class="main-holder">
        <div class="left-text-holder">
        <div id="flip"><a href="#"><img src="<?=IMG?>bg-menu.png"></a></div>
           <div id="panel">   
          <?php
           $user_menu = unserialize($_SESSION['user']);
           if ($user_menu['customer_dashboard_type'] == 's') {
             include('left_bar.php');
           }
           elseif ($user_menu['customer_dashboard_type'] == 'p') {
             include('left_bar_payment.php');
           }
           ?>
        </div>

        </div>
        <div class="right-content">
          <?php include 'top.php';?>
           
           <div class="account-detail">
            <h1><?php echo $sectionheading?></h1>
            <div class="row">
              <div class="containerr">
        <div class="col-sm-12 col-xs-12">
                
                 <?php if(( isset($_GET['error']) ) && ($_GET['error'])): ?>
                <div class="alert alert-danger text text-center  fade in alert-dismissable "> <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
                  <?=$_GET['error']?>
                </div>
                <?php elseif( isset(  $_GET['msg'])): ?>
                <div class="alert alert-success fade in alert-dismissable text text-center  "> <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
                  <?=$_GET['msg']?>
                </div>
                <?php endif; ?>
                
                
                <a href="JavaScript://" class="pull-righ add-address"><span class="label label-success ">+ Add New</span></a>
                <br>
                <br>
                  <table class="table table-striped table-bordered nowrap" cellspacing="0" width="100%">
                      <thead>
                          <th>ID</th>
                            <th>Address</th>
                            <th>Type</th>
                            <th>Added By</th>
                            <th>Action</th>
                        </thead>
                        <tbody>
                          <?php  //echo '<pre>';print_r($history);  echo '</pre>'; 
                          foreach($history as $val):
                          ?>
                            <tr >
                                <td class="id"><?=$val['id']?></td>
                                <td class="address"><?php echo $val['address']?></td>
                                <td class="type"><?php echo $val['type']?></td>
                                <td><?php echo $val['addedby']?></td>
                                <td>
                                  <a href="javascript://" class="edit-address" title="Edit info"><span class="label label-info">Edit</span></a>
                                  <a href="javascript:del('<?=$val['id']?>')" title="Edit info"><span class="label label-danger">Delete</span></a>
                                </td>
                            </tr>
                          <?php endforeach ;?>
                        </tbody>
                    </table>
                
                </div>
            </div>
          </div>

          <div class="footer">
            <div class="footer-logo">
              <a href="#"><img src="<?=IMG?>footer-logo.png"></a>
            </div>
              <p>Copyright©2017 <a href="#"> Magic Mayo</a> All Rights Reserved</p>
          </div>

        </div>
      </div>

      

    </div>

<div class="modal fade" id="modal-add" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="myModalLabel">Add New Address</h4>
            </div>
            <div class="modal-body">

              <form id="add-form">
                <div class="form-group">
                  <label>Address</label>
                  <input type="text" name="address" required class="form-control">
                </div>
                <div class="form-group">
                  <label>Type</label>
                  <select class="form-control" name="type">
                    <option value="web" selected>WEB</option>
                    <option value="api">API</option>
                  </select>
                </div>
                <div class="form-group">
                  <button class="'btn btn-default modal-add-form-btn">Submit</button>
                </div>
              </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-edit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="myModalLabel">Add New Address</h4>
            </div>
            <div class="modal-body">

              <form id="edit-form">
                <input type="hidden" name="id">
                <div class="form-group">
                  <label>Address</label>
                  <input type="text" name="address" required class="form-control">
                </div>
                <div class="form-group">
                  <label>Type</label>
                  <select class="form-control" name="type">
                    <option value="web">WEB</option>
                    <option value="api">API</option>
                  </select>
                </div>
                <div class="form-group">
                  <button class="'btn btn-default modal-add-form-btn">Update</button>
                </div>
              </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>


    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="<?=JS?>bootstrap.min.js"></script>
    <script src="<?=JS?>jquery.dataTables.min.js"></script>
    <script src="<?=JS?>dataTables.fixedHeader.min.js"></script>
    <script> 
      $(document).on('click','.add-address',function(event){
        event.preventDefault();
        $("#modal-add").modal('show');
      })
      $(document).on('submit','#add-form',function(resp){
        event.preventDefault();
        $form = $(this);
        $(".modal-add-form-btn").text('please wait..');
        $.post('<?=BASEURL."users/post-ip-address"?>',{data: $form.serialize()},function(resp){
          resp = $.parseJSON(resp);
          $(".modal-add-form-btn").text('Submit');
          $('.nowrap tbody').html(resp.html);
          alert(resp.msg);
          $("#modal-add").modal('hide');
        })
      }) 
      $(document).on('click','.edit-address',function(event){
        event.preventDefault();
        $this = $(this);

        $("#modal-edit input[name='id']").val($this.parent('td').parent('tr').children('td.id').text());
        $("#modal-edit input[name='address']").val($this.parent('td').parent('tr').children('td.address').text());
        $type = $this.parent('td').parent('tr').children('td.type').text();
        if ($type == 'web') {
          $("#modal-edit select[name='type']").html('<option value="web" selected>WEB</option><option value="api">API</option>');
        }
        else{
          $("#modal-edit select[name='type']").html('<option value="web">WEB</option><option value="api" selected>API</option>');
        }
        $("#modal-edit").modal('show');
      })
      $(document).on('submit','#edit-form',function(resp){
        event.preventDefault();
        $form = $(this);
        $(".modal-add-form-btn").text('please wait..');
        $.post('<?=BASEURL."users/update-ip-address"?>',{data: $form.serialize()},function(resp){
          resp = $.parseJSON(resp);
          $(".modal-add-form-btn").text('Update');
          $('.nowrap tbody').html(resp.html);
          alert(resp.msg);
          $("#modal-add").modal('hide');
        })
      })
      function del(id) {
        cnfr = confirm("are sure you want to delete this address ?");
        if (cnfr) {
          document.location = "<?=BASEURL.'users/delete-ip-address/'?>"+id;
        }
      }
    </script>
  </body>
</html>