
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>jQuery Validation plugin: integration with TinyMCE</title>
<script src="https://jqueryvalidation.org/files/lib/jquery.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.16.0/jquery.validate.min.js"></script>
<script src="//tinymce.cachefly.net/4.1/tinymce.min.js"></script>
<script>
	tinymce.init({
		mode: "textareas",

		setup: function(editor) {
			editor.on('change', function(e) {
				tinymce.triggerSave();
				$("#" + editor.id).valid();
			});
		}

	});
	$(function() {
		var validator = $("#myform").submit(function() {
			// update underlying textarea before submit validation
			tinyMCE.triggerSave();
		}).validate({
			ignore: "",
			rules: {
				title: "required",
				content: "required"
			},
			errorPlacement: function(label, element) {
				// position error label after generated textarea
				if (element.is("textarea")) {
					label.insertAfter(element.next());
				} else {
					label.insertAfter(element)
				}
			}
		});
		validator.focusInvalid = function() {
			// put focus on tinymce on submit validation
			if (this.settings.focusInvalid) {
				try {
					var toFocus = $(this.findLastActive() || this.errorList.length && this.errorList[0].element || []);
					if (toFocus.is("textarea")) {
						tinyMCE.get(toFocus.attr("id")).focus();
					} else {
						toFocus.filter(":visible").focus();
					}
				} catch (e) {
					// ignore IE throwing errors when focusing hidden elements
				}
			}
		}
	})
	</script>

</head>
<body>
<form id="myform" action="">
<h3>TinyMCE4 and Validation Plugin integration example</h3>
<label>Some other field</label>
<input name="title">
<br>
<label>Some richt text</label>
<textarea id="content" name="content" rows="15" cols="80" style="width: 80%"></textarea>
<br>
<input type="submit" name="save" value="Submit">
</form>
</body>
</html>
